-- vi:ft=lua

local Hw = Io.Hw
local hw_bus = Io.system_bus()

-- add devices to io's device tree
Io.Dt.add_children(hw_bus, function()

  -- create a new hardware device
  LED = Hw.Device(function()
    -- Set the 'compatible' IDs for the device
    compatible = {"gpio-led,green", "gpio-led",};

    -- set 'hid' property
    Property.hid = "gpio-led,D1";

    -- Add a GPIO pin as 'gled' resource to the device
    -- on Pandaboard this is the green status LED D1
    Resource.led = Io.Gpio_resource(hw_bus.GPIO.GPIO1, 7, 7);
    -- connect LED to pin 6 of connector J3
    --Resource.wled = Io.Gpio_resource(hw_bus.GPIO.GPIO5, 28, 28);
  end);
end)
