# Libgcc
This package contains the libgcc library from GCC together with make files for
building them inside the L4Re tree.

We maintain one libgcc version per GCC major version, assuming that there are no
breaking changes in libgcc within GCC minor versions, neither in terms of
forward nor backward compatibility.

## Package structure
The `contrib` directory contains unmodified `libgcc`, `gcc` and `include`
directories from each supported major GCC version, but not in there entirety,
only the subset of files required to compile libgcc.

The `build` directory contains the build infrastructure to build libgcc with
L4Re's BID build system.

The `generated` directory contains files required for building libgcc that would
be generated by Autoconf during a regular GCC build.
Fortunately, their content is mostly stable across GCC versions.

The libgcc package is split into five packages:

#### libgcc
Main package, contains contrib code and build infrastructure.
Provides static (`libgcc.a`) and shared (`libgcc_s.so`) variants of the libgcc.

#### libgcc-pure
Provides static variant of libgcc without L4 specific functionality
(`libgcc-pure.a`).

Required when building l4sys, to break a circular dependency, because libgcc
depends on l4sys for L4 specific implementations of certain functionality
(currently limited to atomic operations on arm), but at the same time l4sys
relies on functionality from the libgcc.

In addition, libgcc-pure is used by components such as bootstrap that do not run
in an L4 environment.

#### libgcc-crt
Provides C runtime library object files (`crt<...>.o`), used by ldscripts
package.

#### libgcc_eh
Provides exception handling and unwinding parts of libgcc as a static library
(`libgcc_eh.a`).
Not used when linking against shared libgcc as in that case the functionality in
libgcc_eh is already included in the shared libgcc.

Depends on libpthread, but only for building, not for linking, because the
libpthread symbols are weakly referenced. If the executable using this library
does not link against libpthread, libgcc_eh detects that the program is not
threaded, and works fine without functionality from libpthread.

#### libgcc_eh-pure
Provides exception handling and unwinding parts of libgcc as a static library
without L4 specific functionality, in particular no libpthread, i.e.
single-threaded, (`libgcc_eh-pure.a`).


## Use libgcc from toolchain
Optionally, by enabling the Kconfig option `COMPILER_RT_USE_TOOLCHAIN_LIBGCC`,
instead of building the libgcc for L4Re from source, the libgcc shipped with the
compiler toolchain can be used.
On PowerPC and SPARC this option is forcibly enabled, since it seemed
unreasonable to invest the effort to maintain the libgcc source package for
them.


## Libgcc as shared library
Optionally, by enabling the Kconfig option `COMPILER_RT_LIBGCC_SHARED` it is
possible to link against a shared variant of libgcc (`libgcc_s.so`).
This feature is only available when libgcc is built from source, i.e. not when
using the libgcc shipped with the toolchain.
