# Mag, the GUI Multiplexer {#l4re_servers_mag}

[comment]: # (This is a generated file. Do not change it.)
[comment]: # (Instead, change capdb.yml.)

Mag is the default multiplexer for graphics hardware. Mag is a Nitpicker
derivate that allows secure multiplexing of the graphics and input hardware
among multiple applications and multiple complete windowing environments. It is
not, and does not attempt to be, a fully-fledged window manager.


## Capabilities

None.


## Command Line Options

The following command line options are supported:

` <$FILE.lua | libmag-$LIBNAME.so>`

  As Mag's only command line option it supports loading additional plugins via
  the application's command line.

  Can be used multiple times.

  File path in ROM namespace.
    * Plugins must be either a Lua file or a shared library. Shared libraries
    must be named libmag-$LIBNAME.so.


## Session Factory

As a simple nitpicker clone Mag supports the so-called Xray mode. This mode
displays all session labels and draws a colored frame around them. The session
that currently has the input focus is highlighted. The Xray mode is activated
via the special keys Scroll or NEXTSONG.

Call:   `create(0 [, "label|l=<LABEL>", "col=(string|hex)"])`

* `"label|l=<LABEL>"`

  Set the session's text label to LABEL.

  String value.
    * The label is restricted to a length of 256 characters.


* `"col=(string|hex)"`

  Set the session's color which is used in Xray mode to tint the session's
  screen area and the border drawn around it. The argument can be either one of
  the following letters or a hexadecimal representation of the RGB values.

  The Value for this parameter can be one of the following:

  * `string`

    Define the color by the given character

    Possible values are
      * `r, R`: Red color
      * `g, G`: Green color
      * `b, B`: Blue color
      * `w, W`: White color
      * `y, Y`: Yellow color
      * `v, V`: Magenta color

  * `hex`

    Define the color by its RGB values in hexadecimal representation.

    Hexadecimal number without '0x' prefix.



## Mag Client Session

A client with a mag client session gets access to the whole screen. The client
has to allocate and manage it's own buffers and has to position them on the
screen on its own.

Call:   `create(L4.Proto.Goos [, "default-background|dfl-bg"])`

* `"default-background|dfl-bg"`

  Marks this session as the default background.

  Flag. True if provided.



## Mag Client Framebuffer Session

For a client framebuffer session mag allocates a view of the requested size and
displays it at the requested coordinates on the screen.

Call:   `create(L4.Proto.Goos [, "geometry|g=<GEOMETRY>", "focus", "shaded",
"fixed", "barheight=<X>"])`

* `"geometry|g=<GEOMETRY>"`

  Set the session's geometry and position on the screen. GEOMETRY is provided in
  an X11-style format: `WIDTHxHEIGHT+X_OFFSET+Y_OFFSET`.

  String value.

* `"focus"`

  Set the focus to this session.

  Flag. True if provided.

* `"shaded"`

  The window is collapsed and only the title bar is visible. The window can be
  expanded by clicking into the title bar with the middle mouse button.
  Collapsing and expanding works also independently of this option.

  Flag. True if provided.

* `"fixed"`

  The window cannot be moved on the screen.

  Flag. True if provided.

* `"barheight=<X>"`

  Set the height of the title bar in pixels.

  Numerical value.




## Examples

#### Creating a session
```lua
-- set label to "Linux" and use a light blue color
fb = mag_client:create(L4.Proto.Goos, "l=Linux", "col=98d9ff");
```

#### Requesting a framebuffer via a client framebuffer session
```lua
-- create a window of 640x480 pixels at position (100,100) on the screen.
fb = mag_fb:create(L4.Proto.Goos, "g=640x480+100+100");
```

